@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.NsgSecurityRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Security Rule data model for Network Security Groups.
 * @property access Gets or sets whether network traffic is allowed or denied.
 * Possible values are “Allow” and “Deny”.
 * @property description Gets or sets a description for this rule. Restricted to 140 chars.
 * @property destinationAddressPrefix Gets or sets destination address prefix. CIDR or source IP range.
 *  A “*” can also be used to match all source IPs. Default tags such
 * as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
 * @property destinationPortRange Gets or sets Destination Port or Range. Integer or range between
 * 0 and 65535. A “*” can also be used to match all ports.
 * @property direction Gets or sets the direction of the rule.InBound or Outbound. The
 * direction specifies if rule will be evaluated on incoming or outgoing traffic.
 * @property name Gets or sets the Security rule name.
 * @property priority Gets or sets the priority of the rule. The value can be between
 * 100 and 4096. The priority number must be unique for each rule in the collection.
 * The lower the priority number, the higher the priority of the rule.
 * @property protocol Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
 * @property sourceAddressPrefix Gets or sets source address prefix. CIDR or source IP range. A
 * “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
 * ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
 * rule, specifies where network traffic originates from.
 * @property sourcePortRange Gets or sets Source Port or Range. Integer or range between 0 and
 * 65535. A “*” can also be used to match all ports.
 */
public data class NsgSecurityRuleArgs(
    public val access: Output<String>? = null,
    public val description: Output<String>? = null,
    public val destinationAddressPrefix: Output<String>? = null,
    public val destinationPortRange: Output<String>? = null,
    public val direction: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val sourceAddressPrefix: Output<String>? = null,
    public val sourcePortRange: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.NsgSecurityRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.NsgSecurityRuleArgs =
        com.pulumi.azurenative.migrate.inputs.NsgSecurityRuleArgs.builder()
            .access(access?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddressPrefix(destinationAddressPrefix?.applyValue({ args0 -> args0 }))
            .destinationPortRange(destinationPortRange?.applyValue({ args0 -> args0 }))
            .direction(direction?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .sourceAddressPrefix(sourceAddressPrefix?.applyValue({ args0 -> args0 }))
            .sourcePortRange(sourcePortRange?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NsgSecurityRuleArgs].
 */
@PulumiTagMarker
public class NsgSecurityRuleArgsBuilder internal constructor() {
    private var access: Output<String>? = null

    private var description: Output<String>? = null

    private var destinationAddressPrefix: Output<String>? = null

    private var destinationPortRange: Output<String>? = null

    private var direction: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var sourceAddressPrefix: Output<String>? = null

    private var sourcePortRange: Output<String>? = null

    /**
     * @param value Gets or sets whether network traffic is allowed or denied.
     * Possible values are “Allow” and “Deny”.
     */
    @JvmName("lcsnkkmlxxnxcdvd")
    public suspend fun access(`value`: Output<String>) {
        this.access = value
    }

    /**
     * @param value Gets or sets a description for this rule. Restricted to 140 chars.
     */
    @JvmName("fwcpxbwijsbgjasw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets destination address prefix. CIDR or source IP range.
     *  A “*” can also be used to match all source IPs. Default tags such
     * as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
     */
    @JvmName("ovtmelqlmgrwinjy")
    public suspend fun destinationAddressPrefix(`value`: Output<String>) {
        this.destinationAddressPrefix = value
    }

    /**
     * @param value Gets or sets Destination Port or Range. Integer or range between
     * 0 and 65535. A “*” can also be used to match all ports.
     */
    @JvmName("umpiylcvwjiqqouh")
    public suspend fun destinationPortRange(`value`: Output<String>) {
        this.destinationPortRange = value
    }

    /**
     * @param value Gets or sets the direction of the rule.InBound or Outbound. The
     * direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("jooghxwfxvfxotqe")
    public suspend fun direction(`value`: Output<String>) {
        this.direction = value
    }

    /**
     * @param value Gets or sets the Security rule name.
     */
    @JvmName("blnpumgodpoowrcs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the priority of the rule. The value can be between
     * 100 and 4096. The priority number must be unique for each rule in the collection.
     * The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("qtofmttewqbmhdvn")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
     */
    @JvmName("jbrbbqfsnsnsuqcf")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Gets or sets source address prefix. CIDR or source IP range. A
     * “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
     * ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
     * rule, specifies where network traffic originates from.
     */
    @JvmName("ixwvyeagjyeromlg")
    public suspend fun sourceAddressPrefix(`value`: Output<String>) {
        this.sourceAddressPrefix = value
    }

    /**
     * @param value Gets or sets Source Port or Range. Integer or range between 0 and
     * 65535. A “*” can also be used to match all ports.
     */
    @JvmName("amaftppufogakbql")
    public suspend fun sourcePortRange(`value`: Output<String>) {
        this.sourcePortRange = value
    }

    /**
     * @param value Gets or sets whether network traffic is allowed or denied.
     * Possible values are “Allow” and “Deny”.
     */
    @JvmName("edukmobsqdwgdqve")
    public suspend fun access(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value Gets or sets a description for this rule. Restricted to 140 chars.
     */
    @JvmName("kjnhcovwweebwfmc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets destination address prefix. CIDR or source IP range.
     *  A “*” can also be used to match all source IPs. Default tags such
     * as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
     */
    @JvmName("lysvoxerfvhalglq")
    public suspend fun destinationAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddressPrefix = mapped
    }

    /**
     * @param value Gets or sets Destination Port or Range. Integer or range between
     * 0 and 65535. A “*” can also be used to match all ports.
     */
    @JvmName("jhxttbxejaopvcvy")
    public suspend fun destinationPortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRange = mapped
    }

    /**
     * @param value Gets or sets the direction of the rule.InBound or Outbound. The
     * direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("jwaoctpmunnxlfkh")
    public suspend fun direction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Gets or sets the Security rule name.
     */
    @JvmName("pqslepgxlfhapdwr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the priority of the rule. The value can be between
     * 100 and 4096. The priority number must be unique for each rule in the collection.
     * The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("jvgpyachxbealgmy")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
     */
    @JvmName("xkyspcwipebwuutd")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Gets or sets source address prefix. CIDR or source IP range. A
     * “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
     * ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
     * rule, specifies where network traffic originates from.
     */
    @JvmName("devjgnxnkoosjuby")
    public suspend fun sourceAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddressPrefix = mapped
    }

    /**
     * @param value Gets or sets Source Port or Range. Integer or range between 0 and
     * 65535. A “*” can also be used to match all ports.
     */
    @JvmName("rtqnbjtxiqwaklkp")
    public suspend fun sourcePortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRange = mapped
    }

    internal fun build(): NsgSecurityRuleArgs = NsgSecurityRuleArgs(
        access = access,
        description = description,
        destinationAddressPrefix = destinationAddressPrefix,
        destinationPortRange = destinationPortRange,
        direction = direction,
        name = name,
        priority = priority,
        protocol = protocol,
        sourceAddressPrefix = sourceAddressPrefix,
        sourcePortRange = sourcePortRange,
    )
}
