@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.OnPremiseSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * On-premise settings.
 * @property computeSettings Compute settings.
 * @property facilitySettings Facility settings.
 * @property laborSettings Labour settings.
 * @property managementSettings Management settings.
 * @property networkSettings Network settings.
 * @property securitySettings Security settings.
 * @property storageSettings Storage settings.
 */
public data class OnPremiseSettingsArgs(
    public val computeSettings: Output<ComputeSettingsArgs>,
    public val facilitySettings: Output<FacilitySettingsArgs>,
    public val laborSettings: Output<LaborSettingsArgs>,
    public val managementSettings: Output<ManagementSettingsArgs>? = null,
    public val networkSettings: Output<NetworkSettingsArgs>,
    public val securitySettings: Output<SecuritySettingsArgs>,
    public val storageSettings: Output<StorageSettingsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.OnPremiseSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.OnPremiseSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.OnPremiseSettingsArgs.builder()
            .computeSettings(computeSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .facilitySettings(facilitySettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .laborSettings(laborSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managementSettings(
                managementSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkSettings(networkSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securitySettings(securitySettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageSettings(
                storageSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OnPremiseSettingsArgs].
 */
@PulumiTagMarker
public class OnPremiseSettingsArgsBuilder internal constructor() {
    private var computeSettings: Output<ComputeSettingsArgs>? = null

    private var facilitySettings: Output<FacilitySettingsArgs>? = null

    private var laborSettings: Output<LaborSettingsArgs>? = null

    private var managementSettings: Output<ManagementSettingsArgs>? = null

    private var networkSettings: Output<NetworkSettingsArgs>? = null

    private var securitySettings: Output<SecuritySettingsArgs>? = null

    private var storageSettings: Output<StorageSettingsArgs>? = null

    /**
     * @param value Compute settings.
     */
    @JvmName("tuqarxfpsbahrudt")
    public suspend fun computeSettings(`value`: Output<ComputeSettingsArgs>) {
        this.computeSettings = value
    }

    /**
     * @param value Facility settings.
     */
    @JvmName("vhpgesbrvrfucpxr")
    public suspend fun facilitySettings(`value`: Output<FacilitySettingsArgs>) {
        this.facilitySettings = value
    }

    /**
     * @param value Labour settings.
     */
    @JvmName("evdtdvddcmlkpnhx")
    public suspend fun laborSettings(`value`: Output<LaborSettingsArgs>) {
        this.laborSettings = value
    }

    /**
     * @param value Management settings.
     */
    @JvmName("cksnibriydltncsb")
    public suspend fun managementSettings(`value`: Output<ManagementSettingsArgs>) {
        this.managementSettings = value
    }

    /**
     * @param value Network settings.
     */
    @JvmName("muykoirajxqjtwft")
    public suspend fun networkSettings(`value`: Output<NetworkSettingsArgs>) {
        this.networkSettings = value
    }

    /**
     * @param value Security settings.
     */
    @JvmName("odtsbeigxmqldxgl")
    public suspend fun securitySettings(`value`: Output<SecuritySettingsArgs>) {
        this.securitySettings = value
    }

    /**
     * @param value Storage settings.
     */
    @JvmName("cmsmwpxqsaxxglgs")
    public suspend fun storageSettings(`value`: Output<StorageSettingsArgs>) {
        this.storageSettings = value
    }

    /**
     * @param value Compute settings.
     */
    @JvmName("uqqjmbpnotefgqtx")
    public suspend fun computeSettings(`value`: ComputeSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeSettings = mapped
    }

    /**
     * @param argument Compute settings.
     */
    @JvmName("hpbrotbrwnyxoohw")
    public suspend fun computeSettings(argument: suspend ComputeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.computeSettings = mapped
    }

    /**
     * @param value Facility settings.
     */
    @JvmName("powvxklvqspnttmt")
    public suspend fun facilitySettings(`value`: FacilitySettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.facilitySettings = mapped
    }

    /**
     * @param argument Facility settings.
     */
    @JvmName("uvjsxdchhnpqobqj")
    public suspend fun facilitySettings(argument: suspend FacilitySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = FacilitySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.facilitySettings = mapped
    }

    /**
     * @param value Labour settings.
     */
    @JvmName("vhojwgofoyrocthi")
    public suspend fun laborSettings(`value`: LaborSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.laborSettings = mapped
    }

    /**
     * @param argument Labour settings.
     */
    @JvmName("ttllvsjrmgpfxubu")
    public suspend fun laborSettings(argument: suspend LaborSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = LaborSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.laborSettings = mapped
    }

    /**
     * @param value Management settings.
     */
    @JvmName("yuudeycpsoadnasb")
    public suspend fun managementSettings(`value`: ManagementSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementSettings = mapped
    }

    /**
     * @param argument Management settings.
     */
    @JvmName("vghhtcpwygmfntix")
    public suspend fun managementSettings(argument: suspend ManagementSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managementSettings = mapped
    }

    /**
     * @param value Network settings.
     */
    @JvmName("oroxrgldycefabhp")
    public suspend fun networkSettings(`value`: NetworkSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkSettings = mapped
    }

    /**
     * @param argument Network settings.
     */
    @JvmName("sydnuwiikxymrwpd")
    public suspend fun networkSettings(argument: suspend NetworkSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkSettings = mapped
    }

    /**
     * @param value Security settings.
     */
    @JvmName("pulohskgneyrooov")
    public suspend fun securitySettings(`value`: SecuritySettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securitySettings = mapped
    }

    /**
     * @param argument Security settings.
     */
    @JvmName("tvcodknnxqeadoen")
    public suspend fun securitySettings(argument: suspend SecuritySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SecuritySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securitySettings = mapped
    }

    /**
     * @param value Storage settings.
     */
    @JvmName("cyktlvurujxbowox")
    public suspend fun storageSettings(`value`: StorageSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageSettings = mapped
    }

    /**
     * @param argument Storage settings.
     */
    @JvmName("tcmqtfbnjudyxelf")
    public suspend fun storageSettings(argument: suspend StorageSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StorageSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageSettings = mapped
    }

    internal fun build(): OnPremiseSettingsArgs = OnPremiseSettingsArgs(
        computeSettings = computeSettings ?: throw PulumiNullFieldException("computeSettings"),
        facilitySettings = facilitySettings ?: throw PulumiNullFieldException("facilitySettings"),
        laborSettings = laborSettings ?: throw PulumiNullFieldException("laborSettings"),
        managementSettings = managementSettings,
        networkSettings = networkSettings ?: throw PulumiNullFieldException("networkSettings"),
        securitySettings = securitySettings ?: throw PulumiNullFieldException("securitySettings"),
        storageSettings = storageSettings ?: throw PulumiNullFieldException("storageSettings"),
    )
}
