@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.PortMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * WebApplication port mapping.
 * @property externalPort Gets or sets the External Port.
 * @property internalPort Gets or sets the Internal Port.
 */
public data class PortMappingArgs(
    public val externalPort: Output<Int>? = null,
    public val internalPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.PortMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.PortMappingArgs =
        com.pulumi.azurenative.migrate.inputs.PortMappingArgs.builder()
            .externalPort(externalPort?.applyValue({ args0 -> args0 }))
            .internalPort(internalPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PortMappingArgs].
 */
@PulumiTagMarker
public class PortMappingArgsBuilder internal constructor() {
    private var externalPort: Output<Int>? = null

    private var internalPort: Output<Int>? = null

    /**
     * @param value Gets or sets the External Port.
     */
    @JvmName("iypwulxadwqejmrs")
    public suspend fun externalPort(`value`: Output<Int>) {
        this.externalPort = value
    }

    /**
     * @param value Gets or sets the Internal Port.
     */
    @JvmName("ctbvdsfdbfivkmda")
    public suspend fun internalPort(`value`: Output<Int>) {
        this.internalPort = value
    }

    /**
     * @param value Gets or sets the External Port.
     */
    @JvmName("nyqwkifvghlpinhq")
    public suspend fun externalPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalPort = mapped
    }

    /**
     * @param value Gets or sets the Internal Port.
     */
    @JvmName("topypwgdkpgsnfgs")
    public suspend fun internalPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalPort = mapped
    }

    internal fun build(): PortMappingArgs = PortMappingArgs(
        externalPort = externalPort,
        internalPort = internalPort,
    )
}
