@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.PublicIPAddressResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines the public IP address resource settings.
 * @property domainNameLabel Gets or sets the domain name label.
 * @property fqdn Gets or sets the fully qualified domain name.
 * @property publicIpAllocationMethod Gets or sets public IP allocation method.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Network/publicIPAddresses'.
 * @property sku Gets or sets public IP sku.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 * @property zones Gets or sets public IP zones.
 */
public data class PublicIPAddressResourceSettingsArgs(
    public val domainNameLabel: Output<String>? = null,
    public val fqdn: Output<String>? = null,
    public val publicIpAllocationMethod: Output<String>? = null,
    public val resourceType: Output<String>,
    public val sku: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceGroupName: Output<String>? = null,
    public val targetResourceName: Output<String>,
    public val zones: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.PublicIPAddressResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.PublicIPAddressResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.PublicIPAddressResourceSettingsArgs.builder()
            .domainNameLabel(domainNameLabel?.applyValue({ args0 -> args0 }))
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .publicIpAllocationMethod(publicIpAllocationMethod?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceGroupName(targetResourceGroupName?.applyValue({ args0 -> args0 }))
            .targetResourceName(targetResourceName.applyValue({ args0 -> args0 }))
            .zones(zones?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PublicIPAddressResourceSettingsArgs].
 */
@PulumiTagMarker
public class PublicIPAddressResourceSettingsArgsBuilder internal constructor() {
    private var domainNameLabel: Output<String>? = null

    private var fqdn: Output<String>? = null

    private var publicIpAllocationMethod: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var sku: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceGroupName: Output<String>? = null

    private var targetResourceName: Output<String>? = null

    private var zones: Output<String>? = null

    /**
     * @param value Gets or sets the domain name label.
     */
    @JvmName("dwjlvhokbufopueb")
    public suspend fun domainNameLabel(`value`: Output<String>) {
        this.domainNameLabel = value
    }

    /**
     * @param value Gets or sets the fully qualified domain name.
     */
    @JvmName("rhobhoyninqrttpj")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value Gets or sets public IP allocation method.
     */
    @JvmName("rtwvikgdrptvuriv")
    public suspend fun publicIpAllocationMethod(`value`: Output<String>) {
        this.publicIpAllocationMethod = value
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Network/publicIPAddresses'.
     */
    @JvmName("rhkaepkgojfpypyy")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Gets or sets public IP sku.
     */
    @JvmName("hjxyuxcqqfosrbnu")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("qlqdvdpgvtpuqjkj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("nqfrblejwwmwgvcj")
    public suspend fun targetResourceGroupName(`value`: Output<String>) {
        this.targetResourceGroupName = value
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("elxecbfxufpsrebb")
    public suspend fun targetResourceName(`value`: Output<String>) {
        this.targetResourceName = value
    }

    /**
     * @param value Gets or sets public IP zones.
     */
    @JvmName("fycalvnkngttqgja")
    public suspend fun zones(`value`: Output<String>) {
        this.zones = value
    }

    /**
     * @param value Gets or sets the domain name label.
     */
    @JvmName("pypvlweubomulblb")
    public suspend fun domainNameLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainNameLabel = mapped
    }

    /**
     * @param value Gets or sets the fully qualified domain name.
     */
    @JvmName("jtqykolcftabwsuv")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value Gets or sets public IP allocation method.
     */
    @JvmName("dqtjeckkjjjrjqtl")
    public suspend fun publicIpAllocationMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAllocationMethod = mapped
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Network/publicIPAddresses'.
     */
    @JvmName("anwpchlbabpkmuka")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Gets or sets public IP sku.
     */
    @JvmName("frbknjdcpyhyjplf")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("htvwdvhxmlgxdohf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("twimnvoqthiqnsyy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("ofewgkkpxsuwgadb")
    public suspend fun targetResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("hndgorndxpuvbqhl")
    public suspend fun targetResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceName = mapped
    }

    /**
     * @param value Gets or sets public IP zones.
     */
    @JvmName("kvxhwrvrqafwjsly")
    public suspend fun zones(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): PublicIPAddressResourceSettingsArgs = PublicIPAddressResourceSettingsArgs(
        domainNameLabel = domainNameLabel,
        fqdn = fqdn,
        publicIpAllocationMethod = publicIpAllocationMethod,
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        sku = sku,
        tags = tags,
        targetResourceGroupName = targetResourceGroupName,
        targetResourceName = targetResourceName ?: throw PulumiNullFieldException("targetResourceName"),
        zones = zones,
    )
}
