@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Business case settings.
 * @property azureSettings Azure settings for a business case.
 * @property onPremiseSettings On-premise settings.
 */
public data class SettingsArgs(
    public val azureSettings: Output<AzureSettingsArgs>,
    public val onPremiseSettings: Output<OnPremiseSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SettingsArgs =
        com.pulumi.azurenative.migrate.inputs.SettingsArgs.builder()
            .azureSettings(azureSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .onPremiseSettings(
                onPremiseSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SettingsArgs].
 */
@PulumiTagMarker
public class SettingsArgsBuilder internal constructor() {
    private var azureSettings: Output<AzureSettingsArgs>? = null

    private var onPremiseSettings: Output<OnPremiseSettingsArgs>? = null

    /**
     * @param value Azure settings for a business case.
     */
    @JvmName("mwwtfxhqlxgkrhcg")
    public suspend fun azureSettings(`value`: Output<AzureSettingsArgs>) {
        this.azureSettings = value
    }

    /**
     * @param value On-premise settings.
     */
    @JvmName("ocrvjidpomnxpeji")
    public suspend fun onPremiseSettings(`value`: Output<OnPremiseSettingsArgs>) {
        this.onPremiseSettings = value
    }

    /**
     * @param value Azure settings for a business case.
     */
    @JvmName("sewfpifqnngsfbib")
    public suspend fun azureSettings(`value`: AzureSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSettings = mapped
    }

    /**
     * @param argument Azure settings for a business case.
     */
    @JvmName("fxvnyxvjatmgkulw")
    public suspend fun azureSettings(argument: suspend AzureSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AzureSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureSettings = mapped
    }

    /**
     * @param value On-premise settings.
     */
    @JvmName("rysrjsecxawaakeg")
    public suspend fun onPremiseSettings(`value`: OnPremiseSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onPremiseSettings = mapped
    }

    /**
     * @param argument On-premise settings.
     */
    @JvmName("hjhafnfqwpuxbqwj")
    public suspend fun onPremiseSettings(argument: suspend OnPremiseSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = OnPremiseSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.onPremiseSettings = mapped
    }

    internal fun build(): SettingsArgs = SettingsArgs(
        azureSettings = azureSettings ?: throw PulumiNullFieldException("azureSettings"),
        onPremiseSettings = onPremiseSettings,
    )
}
