@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.VirtualMachineResourceSettingsArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.TargetAvailabilityZone
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Gets or sets the virtual machine resource settings.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Compute/virtualMachines'.
 * @property tags Gets or sets the Resource tags.
 * @property targetAvailabilitySetId Gets or sets the target availability set id for virtual machines not in an availability set at source.
 * @property targetAvailabilityZone Gets or sets the target availability zone.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 * @property targetVmSize Gets or sets the target virtual machine size.
 * @property userManagedIdentities Gets or sets user-managed identities
 */
public data class VirtualMachineResourceSettingsArgs(
    public val resourceType: Output<String>,
    public val tags: Output<Map<String, String>>? = null,
    public val targetAvailabilitySetId: Output<String>? = null,
    public val targetAvailabilityZone: Output<Either<String, TargetAvailabilityZone>>? = null,
    public val targetResourceGroupName: Output<String>? = null,
    public val targetResourceName: Output<String>,
    public val targetVmSize: Output<String>? = null,
    public val userManagedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.VirtualMachineResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.VirtualMachineResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.VirtualMachineResourceSettingsArgs.builder()
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetAvailabilitySetId(targetAvailabilitySetId?.applyValue({ args0 -> args0 }))
            .targetAvailabilityZone(
                targetAvailabilityZone?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .targetResourceGroupName(targetResourceGroupName?.applyValue({ args0 -> args0 }))
            .targetResourceName(targetResourceName.applyValue({ args0 -> args0 }))
            .targetVmSize(targetVmSize?.applyValue({ args0 -> args0 }))
            .userManagedIdentities(
                userManagedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineResourceSettingsArgs].
 */
@PulumiTagMarker
public class VirtualMachineResourceSettingsArgsBuilder internal constructor() {
    private var resourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetAvailabilitySetId: Output<String>? = null

    private var targetAvailabilityZone: Output<Either<String, TargetAvailabilityZone>>? = null

    private var targetResourceGroupName: Output<String>? = null

    private var targetResourceName: Output<String>? = null

    private var targetVmSize: Output<String>? = null

    private var userManagedIdentities: Output<List<String>>? = null

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Compute/virtualMachines'.
     */
    @JvmName("yhbofvjekeyyedjg")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("deixgybkaiwsqdsf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the target availability set id for virtual machines not in an availability set at source.
     */
    @JvmName("xpfwstruritntblh")
    public suspend fun targetAvailabilitySetId(`value`: Output<String>) {
        this.targetAvailabilitySetId = value
    }

    /**
     * @param value Gets or sets the target availability zone.
     */
    @JvmName("dexmwhmgkwxtctkk")
    public suspend fun targetAvailabilityZone(`value`: Output<Either<String, TargetAvailabilityZone>>) {
        this.targetAvailabilityZone = value
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("usuoubrgymuuytok")
    public suspend fun targetResourceGroupName(`value`: Output<String>) {
        this.targetResourceGroupName = value
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("qukwfucyclytgcig")
    public suspend fun targetResourceName(`value`: Output<String>) {
        this.targetResourceName = value
    }

    /**
     * @param value Gets or sets the target virtual machine size.
     */
    @JvmName("rbbgipevalblwoju")
    public suspend fun targetVmSize(`value`: Output<String>) {
        this.targetVmSize = value
    }

    /**
     * @param value Gets or sets user-managed identities
     */
    @JvmName("iewxhfgyehpuatfo")
    public suspend fun userManagedIdentities(`value`: Output<List<String>>) {
        this.userManagedIdentities = value
    }

    @JvmName("joydcmrhkhjljvfq")
    public suspend fun userManagedIdentities(vararg values: Output<String>) {
        this.userManagedIdentities = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets user-managed identities
     */
    @JvmName("ejbxsskjpewvckwj")
    public suspend fun userManagedIdentities(values: List<Output<String>>) {
        this.userManagedIdentities = Output.all(values)
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Compute/virtualMachines'.
     */
    @JvmName("buqqulytqvnxrvho")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("mopvuxmwlnyltfkb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("elvugagbhnhidcaf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the target availability set id for virtual machines not in an availability set at source.
     */
    @JvmName("ngxgbvhfnliireiy")
    public suspend fun targetAvailabilitySetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAvailabilitySetId = mapped
    }

    /**
     * @param value Gets or sets the target availability zone.
     */
    @JvmName("nuyfsbejcpjxivcf")
    public suspend fun targetAvailabilityZone(`value`: Either<String, TargetAvailabilityZone>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAvailabilityZone = mapped
    }

    /**
     * @param value Gets or sets the target availability zone.
     */
    @JvmName("mdhdckreaqwhxftr")
    public fun targetAvailabilityZone(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TargetAvailabilityZone>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetAvailabilityZone = mapped
    }

    /**
     * @param value Gets or sets the target availability zone.
     */
    @JvmName("rugaolawfnkfnavn")
    public fun targetAvailabilityZone(`value`: TargetAvailabilityZone) {
        val toBeMapped = Either.ofRight<String, TargetAvailabilityZone>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetAvailabilityZone = mapped
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("ycwqhxwstcihdeed")
    public suspend fun targetResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("giqiutceeflpoimu")
    public suspend fun targetResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceName = mapped
    }

    /**
     * @param value Gets or sets the target virtual machine size.
     */
    @JvmName("jfnibpgworykykck")
    public suspend fun targetVmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmSize = mapped
    }

    /**
     * @param value Gets or sets user-managed identities
     */
    @JvmName("vhjqmvkhncbcocxt")
    public suspend fun userManagedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userManagedIdentities = mapped
    }

    /**
     * @param values Gets or sets user-managed identities
     */
    @JvmName("ljoddxqdwrxdamdx")
    public suspend fun userManagedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userManagedIdentities = mapped
    }

    internal fun build(): VirtualMachineResourceSettingsArgs = VirtualMachineResourceSettingsArgs(
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        tags = tags,
        targetAvailabilitySetId = targetAvailabilitySetId,
        targetAvailabilityZone = targetAvailabilityZone,
        targetResourceGroupName = targetResourceGroupName,
        targetResourceName = targetResourceName ?: throw PulumiNullFieldException("targetResourceName"),
        targetVmSize = targetVmSize,
        userManagedIdentities = userManagedIdentities,
    )
}
