@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.VsphereLicenseArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.LicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Representation of a vsphere licence.
 * @property basicSupportCost Basic support cost.
 * @property licenseCost Cost of a licence.
 * @property licenseType VSphere licence type.
 * @property productionSupportCost Production support cost.
 */
public data class VsphereLicenseArgs(
    public val basicSupportCost: Output<Double>,
    public val licenseCost: Output<Double>,
    public val licenseType: Output<Either<String, LicenseType>>,
    public val productionSupportCost: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.VsphereLicenseArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.VsphereLicenseArgs =
        com.pulumi.azurenative.migrate.inputs.VsphereLicenseArgs.builder()
            .basicSupportCost(basicSupportCost.applyValue({ args0 -> args0 }))
            .licenseCost(licenseCost.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .productionSupportCost(productionSupportCost.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VsphereLicenseArgs].
 */
@PulumiTagMarker
public class VsphereLicenseArgsBuilder internal constructor() {
    private var basicSupportCost: Output<Double>? = null

    private var licenseCost: Output<Double>? = null

    private var licenseType: Output<Either<String, LicenseType>>? = null

    private var productionSupportCost: Output<Double>? = null

    /**
     * @param value Basic support cost.
     */
    @JvmName("twhjvgwskmbvjvep")
    public suspend fun basicSupportCost(`value`: Output<Double>) {
        this.basicSupportCost = value
    }

    /**
     * @param value Cost of a licence.
     */
    @JvmName("twpwnnpjatwrqhcn")
    public suspend fun licenseCost(`value`: Output<Double>) {
        this.licenseCost = value
    }

    /**
     * @param value VSphere licence type.
     */
    @JvmName("mmnmyjajekiqeifb")
    public suspend fun licenseType(`value`: Output<Either<String, LicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value Production support cost.
     */
    @JvmName("rbabdaqdhkouefdm")
    public suspend fun productionSupportCost(`value`: Output<Double>) {
        this.productionSupportCost = value
    }

    /**
     * @param value Basic support cost.
     */
    @JvmName("wlasifuetsghrkhe")
    public suspend fun basicSupportCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.basicSupportCost = mapped
    }

    /**
     * @param value Cost of a licence.
     */
    @JvmName("dxxjicgalpkxmcni")
    public suspend fun licenseCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseCost = mapped
    }

    /**
     * @param value VSphere licence type.
     */
    @JvmName("llhenatoldttvxua")
    public suspend fun licenseType(`value`: Either<String, LicenseType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value VSphere licence type.
     */
    @JvmName("bgkapcvmgbontibq")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value VSphere licence type.
     */
    @JvmName("daxglipgyhocofto")
    public fun licenseType(`value`: LicenseType) {
        val toBeMapped = Either.ofRight<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Production support cost.
     */
    @JvmName("pntrtqymdpcyinwq")
    public suspend fun productionSupportCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productionSupportCost = mapped
    }

    internal fun build(): VsphereLicenseArgs = VsphereLicenseArgs(
        basicSupportCost = basicSupportCost ?: throw PulumiNullFieldException("basicSupportCost"),
        licenseCost = licenseCost ?: throw PulumiNullFieldException("licenseCost"),
        licenseType = licenseType ?: throw PulumiNullFieldException("licenseType"),
        productionSupportCost = productionSupportCost ?: throw
            PulumiNullFieldException("productionSupportCost"),
    )
}
