@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.WebApplicationConfigurationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ConfigurationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class for web application configurations.
 * @property filePath Gets or sets the configuration file path.
 * @property identifier Gets or sets the identifier for the configuration.
 * @property isDeploymentTimeEditable Gets or sets a value indicating whether the configuration is edited or not by the user.
 * @property localFilePath Gets or sets the configuration local file path.
 * @property name Gets or sets the configuration name.
 * @property secretStoreDetails
 * @property section Gets or sets the configuration section in the file.
 * @property targetFilePath Gets or sets the configuration target file path.
 * @property type Gets or sets the configuration type.
 * @property value Gets or sets the configuration value.
 */
public data class WebApplicationConfigurationArgs(
    public val filePath: Output<String>? = null,
    public val identifier: Output<String>? = null,
    public val isDeploymentTimeEditable: Output<Boolean>? = null,
    public val localFilePath: Output<String>? = null,
    public val name: Output<String>? = null,
    public val secretStoreDetails: Output<SecretStoreDetailsArgs>? = null,
    public val section: Output<String>? = null,
    public val targetFilePath: Output<String>? = null,
    public val type: Output<Either<String, ConfigurationType>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.WebApplicationConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.WebApplicationConfigurationArgs =
        com.pulumi.azurenative.migrate.inputs.WebApplicationConfigurationArgs.builder()
            .filePath(filePath?.applyValue({ args0 -> args0 }))
            .identifier(identifier?.applyValue({ args0 -> args0 }))
            .isDeploymentTimeEditable(isDeploymentTimeEditable?.applyValue({ args0 -> args0 }))
            .localFilePath(localFilePath?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .secretStoreDetails(
                secretStoreDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .section(section?.applyValue({ args0 -> args0 }))
            .targetFilePath(targetFilePath?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebApplicationConfigurationArgs].
 */
@PulumiTagMarker
public class WebApplicationConfigurationArgsBuilder internal constructor() {
    private var filePath: Output<String>? = null

    private var identifier: Output<String>? = null

    private var isDeploymentTimeEditable: Output<Boolean>? = null

    private var localFilePath: Output<String>? = null

    private var name: Output<String>? = null

    private var secretStoreDetails: Output<SecretStoreDetailsArgs>? = null

    private var section: Output<String>? = null

    private var targetFilePath: Output<String>? = null

    private var type: Output<Either<String, ConfigurationType>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Gets or sets the configuration file path.
     */
    @JvmName("gprvckjutyjfnhrs")
    public suspend fun filePath(`value`: Output<String>) {
        this.filePath = value
    }

    /**
     * @param value Gets or sets the identifier for the configuration.
     */
    @JvmName("bbwybnyrjkvmremt")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value Gets or sets a value indicating whether the configuration is edited or not by the user.
     */
    @JvmName("ahkbtlcueegnmjee")
    public suspend fun isDeploymentTimeEditable(`value`: Output<Boolean>) {
        this.isDeploymentTimeEditable = value
    }

    /**
     * @param value Gets or sets the configuration local file path.
     */
    @JvmName("vnbiwseptouorxtt")
    public suspend fun localFilePath(`value`: Output<String>) {
        this.localFilePath = value
    }

    /**
     * @param value Gets or sets the configuration name.
     */
    @JvmName("meuqmqjkcggkgyne")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("xgyqsiuorclbommr")
    public suspend fun secretStoreDetails(`value`: Output<SecretStoreDetailsArgs>) {
        this.secretStoreDetails = value
    }

    /**
     * @param value Gets or sets the configuration section in the file.
     */
    @JvmName("wvwjlqimpxrajcxv")
    public suspend fun section(`value`: Output<String>) {
        this.section = value
    }

    /**
     * @param value Gets or sets the configuration target file path.
     */
    @JvmName("xtydpoaeaaegvkmx")
    public suspend fun targetFilePath(`value`: Output<String>) {
        this.targetFilePath = value
    }

    /**
     * @param value Gets or sets the configuration type.
     */
    @JvmName("ywktcorxxnwuquxa")
    public suspend fun type(`value`: Output<Either<String, ConfigurationType>>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the configuration value.
     */
    @JvmName("kycakepknifapiub")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Gets or sets the configuration file path.
     */
    @JvmName("twwymhmjxbekeuul")
    public suspend fun filePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePath = mapped
    }

    /**
     * @param value Gets or sets the identifier for the configuration.
     */
    @JvmName("wsojumucpxvabhjd")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether the configuration is edited or not by the user.
     */
    @JvmName("ypvrbqkcwtjdptwc")
    public suspend fun isDeploymentTimeEditable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDeploymentTimeEditable = mapped
    }

    /**
     * @param value Gets or sets the configuration local file path.
     */
    @JvmName("imdrwwxhfahngwlm")
    public suspend fun localFilePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localFilePath = mapped
    }

    /**
     * @param value Gets or sets the configuration name.
     */
    @JvmName("ptkthgprbjqriwxc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("vpfrpmgqttfcbebe")
    public suspend fun secretStoreDetails(`value`: SecretStoreDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStoreDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wjimmmlhbxjgbdrg")
    public suspend fun secretStoreDetails(argument: suspend SecretStoreDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = SecretStoreDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secretStoreDetails = mapped
    }

    /**
     * @param value Gets or sets the configuration section in the file.
     */
    @JvmName("bgouaablyirlqvhw")
    public suspend fun section(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.section = mapped
    }

    /**
     * @param value Gets or sets the configuration target file path.
     */
    @JvmName("jpmkdtcqcqntjoxn")
    public suspend fun targetFilePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetFilePath = mapped
    }

    /**
     * @param value Gets or sets the configuration type.
     */
    @JvmName("rrwrfujkfuovqngy")
    public suspend fun type(`value`: Either<String, ConfigurationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the configuration type.
     */
    @JvmName("bjflbdmcjbamdklx")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the configuration type.
     */
    @JvmName("bsfxsopotcruyiew")
    public fun type(`value`: ConfigurationType) {
        val toBeMapped = Either.ofRight<String, ConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the configuration value.
     */
    @JvmName("spdlncmhdseipuyw")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): WebApplicationConfigurationArgs = WebApplicationConfigurationArgs(
        filePath = filePath,
        identifier = identifier,
        isDeploymentTimeEditable = isDeploymentTimeEditable,
        localFilePath = localFilePath,
        name = name,
        secretStoreDetails = secretStoreDetails,
        section = section,
        targetFilePath = targetFilePath,
        type = type,
        `value` = `value`,
    )
}
