@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Data model of AKS Assessment Settings.
 * @property azureLocation Gets or sets azure location.
 * @property category Gets or sets azure VM category.
 * @property consolidation Gets or sets consolidation type.
 * @property currency Gets or sets currency.
 * @property discountPercentage Gets or sets discount percentage.
 * @property environmentType Gets or sets environment type.
 * @property licensingProgram Gets or sets licensing program.
 * @property performanceData Gets or sets performance data settings.
 * @property pricingTier Gets or sets pricing tier.
 * @property savingsOptions Gets or sets savings options.
 * @property scalingFactor Gets or sets scaling factor.
 * @property sizingCriteria Gets or sets sizing criteria.
 */
public data class AKSAssessmentSettingsResponse(
    public val azureLocation: String,
    public val category: String,
    public val consolidation: String,
    public val currency: String,
    public val discountPercentage: Double? = null,
    public val environmentType: String,
    public val licensingProgram: String,
    public val performanceData: PerfDataSettingsResponse? = null,
    public val pricingTier: String,
    public val savingsOptions: String,
    public val scalingFactor: Double? = null,
    public val sizingCriteria: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.AKSAssessmentSettingsResponse): AKSAssessmentSettingsResponse = AKSAssessmentSettingsResponse(
            azureLocation = javaType.azureLocation(),
            category = javaType.category(),
            consolidation = javaType.consolidation(),
            currency = javaType.currency(),
            discountPercentage = javaType.discountPercentage().map({ args0 -> args0 }).orElse(null),
            environmentType = javaType.environmentType(),
            licensingProgram = javaType.licensingProgram(),
            performanceData = javaType.performanceData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PerfDataSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            pricingTier = javaType.pricingTier(),
            savingsOptions = javaType.savingsOptions(),
            scalingFactor = javaType.scalingFactor().map({ args0 -> args0 }).orElse(null),
            sizingCriteria = javaType.sizingCriteria(),
        )
    }
}
