@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * AKS Deployment Specification.
 * @property kubernetesObjectsYaml Gets or sets the Merged Deployment and service Yaml.
 * @property loadBalancerType Gets or sets the load balancer type.
 * @property replicaCount Gets or sets the replica count to be created in AKS.
 */
public data class AKSDeploymentSpecificationResponse(
    public val kubernetesObjectsYaml: String? = null,
    public val loadBalancerType: String? = null,
    public val replicaCount: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.AKSDeploymentSpecificationResponse): AKSDeploymentSpecificationResponse = AKSDeploymentSpecificationResponse(
            kubernetesObjectsYaml = javaType.kubernetesObjectsYaml().map({ args0 -> args0 }).orElse(null),
            loadBalancerType = javaType.loadBalancerType().map({ args0 -> args0 }).orElse(null),
            replicaCount = javaType.replicaCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
