@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ApacheTomcat workload instance model custom properties.
 * @property apacheTomcatWebApplication ApacheTomcat web application.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'ApacheTomcatWorkloadInstanceModelCustomProperties'.
 * @property webAppArmId Gets or sets the Web application ARM id.
 * @property webAppSiteName Gets or sets the Web application site name.
 */
public data class ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse(
    public val apacheTomcatWebApplication: ApacheTomcatWebApplicationResponse? = null,
    public val instanceType: String,
    public val webAppArmId: String? = null,
    public val webAppSiteName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse): ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse =
            ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse(
                apacheTomcatWebApplication = javaType.apacheTomcatWebApplication().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.migrate.kotlin.outputs.ApacheTomcatWebApplicationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                instanceType = javaType.instanceType(),
                webAppArmId = javaType.webAppArmId().map({ args0 -> args0 }).orElse(null),
                webAppSiteName = javaType.webAppSiteName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
