@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Class for app insight monitoring properties.
 * @property appInsightsName Gets or sets the app insights name.
 * @property isEnabled Gets or sets a value indicating whether monitoring is enabled.
 * @property region Gets or sets the region.
 * @property resourceGroup Gets or sets the resource group of the resource.
 * @property secretStoreDetails
 * @property subscriptionId Gets or sets the subscription id of the resource.
 */
public data class AppInsightMonitoringPropertiesResponse(
    public val appInsightsName: String? = null,
    public val isEnabled: Boolean? = null,
    public val region: String? = null,
    public val resourceGroup: String? = null,
    public val secretStoreDetails: SecretStoreDetailsResponse? = null,
    public val subscriptionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.AppInsightMonitoringPropertiesResponse): AppInsightMonitoringPropertiesResponse = AppInsightMonitoringPropertiesResponse(
            appInsightsName = javaType.appInsightsName().map({ args0 -> args0 }).orElse(null),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            secretStoreDetails = javaType.secretStoreDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SecretStoreDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
