@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the properties for automatic resolution.
 * @property moveResourceId Gets the MoveResource ARM ID of
 * the dependent resource if the resolution type is Automatic.
 */
public data class AutomaticResolutionPropertiesResponse(
    public val moveResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.AutomaticResolutionPropertiesResponse): AutomaticResolutionPropertiesResponse = AutomaticResolutionPropertiesResponse(
            moveResourceId = javaType.moveResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
