@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Class for automation artifact.
 * @property artifacts Gets or sets the artifacts.
 * @property azureFileShareProfile Azure file share profile for hydration of application folders not mounted on
 * the container file system.
 * @property status Gets or sets the status of automation artifacts.
 */
public data class AutomationArtifactResponse(
    public val artifacts: Map<String, String>? = null,
    public val azureFileShareProfile: AzureFileShareHydrationProfileResponse? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.AutomationArtifactResponse): AutomationArtifactResponse = AutomationArtifactResponse(
            artifacts = javaType.artifacts().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            azureFileShareProfile = javaType.azureFileShareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.AzureFileShareHydrationProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
