@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Gets or sets the availability set resource settings.
 * @property faultDomain Gets or sets the target fault domain.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Compute/availabilitySets'.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 * @property updateDomain Gets or sets the target update domain.
 */
public data class AvailabilitySetResourceSettingsResponse(
    public val faultDomain: Int? = null,
    public val resourceType: String,
    public val tags: Map<String, String>? = null,
    public val targetResourceGroupName: String? = null,
    public val targetResourceName: String,
    public val updateDomain: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.AvailabilitySetResourceSettingsResponse): AvailabilitySetResourceSettingsResponse = AvailabilitySetResourceSettingsResponse(
            faultDomain = javaType.faultDomain().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceGroupName = javaType.targetResourceGroupName().map({ args0 -> args0 }).orElse(null),
            targetResourceName = javaType.targetResourceName(),
            updateDomain = javaType.updateDomain().map({ args0 -> args0 }).orElse(null),
        )
    }
}
