@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure file share profile for hydration of application folders not mounted on
 * the container file system.
 * @property azureFileShareDirPath Gets or sets the cloud directory path of the directory on azure file share.
 * @property azureFileShareName Gets or sets the name of the azure file share.
 * @property azureFileShareResourceGroup Gets or sets the name of the azure file share resource group.
 * @property azureFileShareStorageAccount Gets or sets the name of the azure file share storage account.
 * @property azureFileShareSubscriptionId Gets or sets the subscription id of the azure file share.
 */
public data class AzureFileShareHydrationProfileResponse(
    public val azureFileShareDirPath: String? = null,
    public val azureFileShareName: String? = null,
    public val azureFileShareResourceGroup: String? = null,
    public val azureFileShareStorageAccount: String? = null,
    public val azureFileShareSubscriptionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.AzureFileShareHydrationProfileResponse): AzureFileShareHydrationProfileResponse = AzureFileShareHydrationProfileResponse(
            azureFileShareDirPath = javaType.azureFileShareDirPath().map({ args0 -> args0 }).orElse(null),
            azureFileShareName = javaType.azureFileShareName().map({ args0 -> args0 }).orElse(null),
            azureFileShareResourceGroup = javaType.azureFileShareResourceGroup().map({ args0 ->
                args0
            }).orElse(null),
            azureFileShareStorageAccount = javaType.azureFileShareStorageAccount().map({ args0 ->
                args0
            }).orElse(null),
            azureFileShareSubscriptionId = javaType.azureFileShareSubscriptionId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
