@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Azure settings for a business case.
 * @property avsLaborCostPercentage Gets Avs labour cost percentage.
 * @property businessCaseType Migration Strategy.
 * @property comfortFactor Gets comfort factor.
 * @property currency Business case Currency.
 * @property discountPercentage Gets azure Discount percentage.
 * @property iaasLaborCostPercentage Gets IaaS labour cost percentage.
 * @property infrastructureGrowthRate Gets infrastructure growth rate.
 * @property networkCostPercentage Gets network cost percentage.
 * @property paasLaborCostPercentage Gets PaaS labour cost percentage.
 * @property perYearMigrationCompletionPercentage Gets migration completion percentage per year.
 * @property performanceDataEndTime Gets end time to use for performance.
 * @property performanceDataStartTime Gets start time to use for performance.
 * @property performanceUtilizationPercentile Gets utilization percentile for performance.
 * @property savingsOption Gets the business case savings option type.
 * @property targetLocation Gets or sets azure location.
 * @property wacc Gets wACC percentage.
 * @property workloadDiscoverySource Workload discovery source.
 */
public data class AzureSettingsResponse(
    public val avsLaborCostPercentage: Double? = null,
    public val businessCaseType: String? = null,
    public val comfortFactor: Double? = null,
    public val currency: String,
    public val discountPercentage: Double? = null,
    public val iaasLaborCostPercentage: Double? = null,
    public val infrastructureGrowthRate: Double? = null,
    public val networkCostPercentage: Double? = null,
    public val paasLaborCostPercentage: Double? = null,
    public val perYearMigrationCompletionPercentage: Map<String, Double>? = null,
    public val performanceDataEndTime: String? = null,
    public val performanceDataStartTime: String? = null,
    public val performanceUtilizationPercentile: Double? = null,
    public val savingsOption: String? = null,
    public val targetLocation: String,
    public val wacc: Double? = null,
    public val workloadDiscoverySource: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.AzureSettingsResponse): AzureSettingsResponse = AzureSettingsResponse(
            avsLaborCostPercentage = javaType.avsLaborCostPercentage().map({ args0 -> args0 }).orElse(null),
            businessCaseType = javaType.businessCaseType().map({ args0 -> args0 }).orElse(null),
            comfortFactor = javaType.comfortFactor().map({ args0 -> args0 }).orElse(null),
            currency = javaType.currency(),
            discountPercentage = javaType.discountPercentage().map({ args0 -> args0 }).orElse(null),
            iaasLaborCostPercentage = javaType.iaasLaborCostPercentage().map({ args0 -> args0 }).orElse(null),
            infrastructureGrowthRate = javaType.infrastructureGrowthRate().map({ args0 -> args0 }).orElse(null),
            networkCostPercentage = javaType.networkCostPercentage().map({ args0 -> args0 }).orElse(null),
            paasLaborCostPercentage = javaType.paasLaborCostPercentage().map({ args0 -> args0 }).orElse(null),
            perYearMigrationCompletionPercentage = javaType.perYearMigrationCompletionPercentage().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            performanceDataEndTime = javaType.performanceDataEndTime().map({ args0 -> args0 }).orElse(null),
            performanceDataStartTime = javaType.performanceDataStartTime().map({ args0 -> args0 }).orElse(null),
            performanceUtilizationPercentile = javaType.performanceUtilizationPercentile().map({ args0 ->
                args0
            }).orElse(null),
            savingsOption = javaType.savingsOption().map({ args0 -> args0 }).orElse(null),
            targetLocation = javaType.targetLocation(),
            wacc = javaType.wacc().map({ args0 -> args0 }).orElse(null),
            workloadDiscoverySource = javaType.workloadDiscoverySource().map({ args0 -> args0 }).orElse(null),
        )
    }
}
