@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Binding for a web application.
 * @property cert WebApplication certificate.
 * @property hostName Gets or sets the binding host name.
 * @property id Gets the ID.
 * @property ipAddress Gets or sets the IP Address.
 * @property port Gets or sets the application port.
 * @property portMapping WebApplication port mapping.
 * @property protocol Gets or sets the protocol.
 */
public data class BindingResponse(
    public val cert: CertResponse? = null,
    public val hostName: String? = null,
    public val id: String,
    public val ipAddress: String? = null,
    public val port: String? = null,
    public val portMapping: PortMappingResponse? = null,
    public val protocol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.BindingResponse): BindingResponse = BindingResponse(
            cert = javaType.cert().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.CertResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            portMapping = javaType.portMapping().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PortMappingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
