@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Collector agent property class.
 * @property id Gets the collector agent id.
 * @property lastHeartbeatUtc Gets the collector last heartbeat time.
 * @property spnDetails Gets or sets the SPN details.
 * @property version Gets the collector agent version.
 */
public data class CollectorAgentPropertiesBaseResponse(
    public val id: String? = null,
    public val lastHeartbeatUtc: String? = null,
    public val spnDetails: CollectorAgentSpnPropertiesBaseResponse? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.CollectorAgentPropertiesBaseResponse): CollectorAgentPropertiesBaseResponse = CollectorAgentPropertiesBaseResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            lastHeartbeatUtc = javaType.lastHeartbeatUtc().map({ args0 -> args0 }).orElse(null),
            spnDetails = javaType.spnDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentSpnPropertiesBaseResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
