@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Collector agent SPN details class.
 * @property applicationId Gets the AAD application id.
 * @property audience Gets the AAD audience url.
 * @property authority Gets the AAD authority endpoint.
 * @property objectId Gets the object id of the AAD application.
 * @property tenantId Gets the tenant id of the AAD application.
 */
public data class CollectorAgentSpnPropertiesBaseResponse(
    public val applicationId: String? = null,
    public val audience: String? = null,
    public val authority: String? = null,
    public val objectId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.CollectorAgentSpnPropertiesBaseResponse): CollectorAgentSpnPropertiesBaseResponse = CollectorAgentSpnPropertiesBaseResponse(
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            audience = javaType.audience().map({ args0 -> args0 }).orElse(null),
            authority = javaType.authority().map({ args0 -> args0 }).orElse(null),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
