@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationId Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 * @property audience Intended audience for the service principal.
 * @property authority AAD Authority URL which was used to request the token for the service principal.
 * @property objectId Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 * @property tenantId Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
 */
public data class CollectorBodyAgentSpnPropertiesResponse(
    public val applicationId: String? = null,
    public val audience: String? = null,
    public val authority: String? = null,
    public val objectId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.CollectorBodyAgentSpnPropertiesResponse): CollectorBodyAgentSpnPropertiesResponse = CollectorBodyAgentSpnPropertiesResponse(
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            audience = javaType.audience().map({ args0 -> args0 }).orElse(null),
            authority = javaType.authority().map({ args0 -> args0 }).orElse(null),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
