@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property agentProperties
 * @property createdTimestamp Time when this collector was created. Date-Time represented in ISO-8601 format.
 * @property discoverySiteId The ARM id of the discovery service site.
 * @property updatedTimestamp Time when this collector was updated. Date-Time represented in ISO-8601 format.
 */
public data class CollectorPropertiesResponse(
    public val agentProperties: CollectorAgentPropertiesResponse? = null,
    public val createdTimestamp: String,
    public val discoverySiteId: String? = null,
    public val updatedTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.CollectorPropertiesResponse): CollectorPropertiesResponse = CollectorPropertiesResponse(
            agentProperties = javaType.agentProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdTimestamp = javaType.createdTimestamp(),
            discoverySiteId = javaType.discoverySiteId().map({ args0 -> args0 }).orElse(null),
            updatedTimestamp = javaType.updatedTimestamp(),
        )
    }
}
