@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Class representing the databases solution summary.
 * @property databaseInstancesAssessedCount Gets or sets the count of database instances assessed.
 * @property databasesAssessedCount Gets or sets the count of databases assessed.
 * @property instanceType Gets the Instance type.
 * Expected value is 'Databases'.
 * @property migrationReadyCount Gets or sets the count of databases ready for migration.
 */
public data class DatabasesSolutionSummaryResponse(
    public val databaseInstancesAssessedCount: Int? = null,
    public val databasesAssessedCount: Int? = null,
    public val instanceType: String,
    public val migrationReadyCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.DatabasesSolutionSummaryResponse): DatabasesSolutionSummaryResponse = DatabasesSolutionSummaryResponse(
            databaseInstancesAssessedCount = javaType.databaseInstancesAssessedCount().map({ args0 ->
                args0
            }).orElse(null),
            databasesAssessedCount = javaType.databasesAssessedCount().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            migrationReadyCount = javaType.migrationReadyCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
