@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Second level entity for virtual directories.
 * @property id Gets the ID.
 * @property physical Gets or sets the physical path of the directory on the web server.
 * @property virtual Gets or sets the virtual path for the directory.
 */
public data class DirectoryPathResponse(
    public val id: String,
    public val physical: String? = null,
    public val virtual: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.DirectoryPathResponse): DirectoryPathResponse = DirectoryPathResponse(
            id = javaType.id(),
            physical = javaType.physical().map({ args0 -> args0 }).orElse(null),
            virtual = javaType.virtual().map({ args0 -> args0 }).orElse(null),
        )
    }
}
