@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the disk encryption set resource settings.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Compute/diskEncryptionSets'.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 */
public data class DiskEncryptionSetResourceSettingsResponse(
    public val resourceType: String,
    public val targetResourceGroupName: String? = null,
    public val targetResourceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.DiskEncryptionSetResourceSettingsResponse): DiskEncryptionSetResourceSettingsResponse = DiskEncryptionSetResourceSettingsResponse(
            resourceType = javaType.resourceType(),
            targetResourceGroupName = javaType.targetResourceGroupName().map({ args0 -> args0 }).orElse(null),
            targetResourceName = javaType.targetResourceName(),
        )
    }
}
