@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ARM model of AKS Assessment.
 * @property details Gets AKS Assessment Details.
 * @property eTag If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property provisioningState Gets the provisioning state.
 * @property scope Gets or sets scope parameters to identify inventory items for assessment.
 * @property settings Gets or sets AKS Assessment Settings.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAksAssessmentOperationResult(
    public val details: AKSAssessmentDetailsResponse,
    public val eTag: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val scope: AssessmentScopeParametersResponse? = null,
    public val settings: AKSAssessmentSettingsResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetAksAssessmentOperationResult): GetAksAssessmentOperationResult = GetAksAssessmentOperationResult(
            details = javaType.details().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.AKSAssessmentDetailsResponse.Companion.toKotlin(args0)
            }),
            eTag = javaType.eTag(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            scope = javaType.scope().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.AssessmentScopeParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            settings = javaType.settings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.AKSAssessmentSettingsResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
