@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Assessment project site resource.
 * @property assessmentSolutionId Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
 * @property createdTimestamp Time when this project was created. Date-Time represented in ISO-8601 format.
 * @property customerStorageAccountArmId The ARM id of the storage account used for interactions when public access is
 * disabled.
 * @property customerWorkspaceId The ARM id of service map workspace created by customer.
 * @property customerWorkspaceLocation Location of service map workspace created by customer.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property privateEndpointConnections The list of private endpoint connections to the project.
 * @property projectStatus Assessment project status.
 * @property provisioningState The status of the last operation.
 * @property publicNetworkAccess This value can be set to 'enabled' to avoid breaking changes on existing
 * customer resources and templates. If set to 'disabled', traffic over public
 * interface is not allowed, and private endpoint connections would be the
 * exclusive access method.
 * @property serviceEndpoint Endpoint at which the collector agent can call agent REST API.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatedTimestamp Time when this project was last updated. Date-Time represented in ISO-8601
 * format.
 */
public data class GetAssessmentProjectsOperationResult(
    public val assessmentSolutionId: String? = null,
    public val createdTimestamp: String,
    public val customerStorageAccountArmId: String? = null,
    public val customerWorkspaceId: String? = null,
    public val customerWorkspaceLocation: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val projectStatus: String? = null,
    public val provisioningState: String? = null,
    public val publicNetworkAccess: String? = null,
    public val serviceEndpoint: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val updatedTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetAssessmentProjectsOperationResult): GetAssessmentProjectsOperationResult = GetAssessmentProjectsOperationResult(
            assessmentSolutionId = javaType.assessmentSolutionId().map({ args0 -> args0 }).orElse(null),
            createdTimestamp = javaType.createdTimestamp(),
            customerStorageAccountArmId = javaType.customerStorageAccountArmId().map({ args0 ->
                args0
            }).orElse(null),
            customerWorkspaceId = javaType.customerWorkspaceId().map({ args0 -> args0 }).orElse(null),
            customerWorkspaceLocation = javaType.customerWorkspaceLocation().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            projectStatus = javaType.projectStatus().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            serviceEndpoint = javaType.serviceEndpoint(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            updatedTimestamp = javaType.updatedTimestamp(),
        )
    }
}
