@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A group created in a Migration project.
 * @property eTag For optimistic concurrency control.
 * @property id Path reference to this group. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}
 * @property name Name of the group.
 * @property properties Properties of the group.
 * @property type Type of the object = [Microsoft&#46;Migrate/assessmentProjects/groups].
 */
public data class GetGroupResult(
    public val eTag: String? = null,
    public val id: String,
    public val name: String,
    public val properties: GroupPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetGroupResult): GetGroupResult = GetGroupResult(
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.GroupPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
