@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Import collector resource.
 * @property createdTimestamp Gets the Timestamp when collector was created.
 * @property discoverySiteId Gets the discovery site id.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatedTimestamp Timestamp when collector was last updated.
 */
public data class GetImportCollectorsOperationResult(
    public val createdTimestamp: String,
    public val discoverySiteId: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatedTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetImportCollectorsOperationResult): GetImportCollectorsOperationResult = GetImportCollectorsOperationResult(
            createdTimestamp = javaType.createdTimestamp(),
            discoverySiteId = javaType.discoverySiteId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatedTimestamp = javaType.updatedTimestamp(),
        )
    }
}
