@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * MigrateAgent model.
 * @property id Gets or sets the Id of the resource.
 * @property name Gets or sets the name of the resource.
 * @property properties MigrateAgent model properties.
 * @property systemData
 * @property tags Gets or sets the resource tags.
 * @property type Gets or sets the type of the resource.
 */
public data class GetMigrateAgentResult(
    public val id: String,
    public val name: String,
    public val properties: MigrateAgentModelPropertiesResponse,
    public val systemData: MigrateAgentModelResponseSystemData,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetMigrateAgentResult): GetMigrateAgentResult = GetMigrateAgentResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.MigrateAgentModelPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.MigrateAgentModelResponseSystemData.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
