@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Migrate Project REST Resource.
 * @property eTag Gets or sets the eTag for concurrency control.
 * @property id Gets the relative URL to get this migrate project.
 * @property location Gets or sets the Azure location in which migrate project is created.
 * @property name Gets the name of the migrate project.
 * @property properties Gets or sets the nested properties.
 * @property tags Gets or sets the tags.
 * @property type Handled by resource provider. Type = Microsoft.Migrate/MigrateProject.
 */
public data class GetMigrateProjectResult(
    public val eTag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: MigrateProjectPropertiesResponse,
    public val tags: MigrateProjectResponseTags? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetMigrateProjectResult): GetMigrateProjectResult = GetMigrateProjectResult(
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.MigrateProjectPropertiesResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.MigrateProjectResponseTags.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
