@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Migrate project.
 * @property eTag For optimistic concurrency control.
 * @property id Path reference to this project /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{projectName}
 * @property location Azure location in which project is created.
 * @property name Name of the project.
 * @property properties Properties of a migrate project.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type Type of the object = [Microsoft&#46;Migrate/migrateProjects].
 */
public data class GetMigrateProjectsControllerMigrateProjectResult(
    public val eTag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: MigrateProjectPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetMigrateProjectsControllerMigrateProjectResult): GetMigrateProjectsControllerMigrateProjectResult =
            GetMigrateProjectsControllerMigrateProjectResult(
                eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                location = javaType.location().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                properties = javaType.properties().let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.MigrateProjectPropertiesResponse.Companion.toKotlin(args0)
                }),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
