@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * ModernizeProject model.
 * @property id Gets or sets the Id of the resource.
 * @property identity
 * @property location Gets or sets the location of the modernizeProject.
 * @property name Gets or sets the name of the resource.
 * @property properties ModernizeProject properties.
 * @property systemData
 * @property tags Gets or sets the resource tags.
 * @property type Gets or sets the type of the resource.
 */
public data class GetModernizeProjectResult(
    public val id: String,
    public val identity: ResourceIdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: ModernizeProjectModelPropertiesResponse,
    public val systemData: ModernizeProjectModelResponseSystemData,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetModernizeProjectResult): GetModernizeProjectResult = GetModernizeProjectResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.ModernizeProjectModelPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.ModernizeProjectModelResponseSystemData.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
