@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the move resource.
 * @property id Fully qualified resource Id for the resource.
 * @property name The name of the resource
 * @property properties Defines the move resource properties.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class GetMoveResourceResult(
    public val id: String,
    public val name: String,
    public val properties: MoveResourcePropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetMoveResourceResult): GetMoveResourceResult = GetMoveResourceResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.MoveResourcePropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
