@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * REST model used to encapsulate the user visible state of a PrivateEndpoint.
 * @property eTag Gets the tag for optimistic concurrency control.
 * @property id Relative URL to get this Sites.
 * @property name Gets the name of the resource.
 * @property properties Gets the properties of the object.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type Gets the resource type.
 */
public data class GetPrivateEndpointConnectionControllerPrivateEndpointConnectionResult(
    public val eTag: String,
    public val id: String,
    public val name: String,
    public val properties: PrivateEndpointConnectionPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetPrivateEndpointConnectionControllerPrivateEndpointConnectionResult): GetPrivateEndpointConnectionControllerPrivateEndpointConnectionResult =
            GetPrivateEndpointConnectionControllerPrivateEndpointConnectionResult(
                eTag = javaType.eTag(),
                id = javaType.id(),
                name = javaType.name(),
                properties = javaType.properties().let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionPropertiesResponse.Companion.toKotlin(args0)
                }),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
