@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A private endpoint connection for a project.
 * @property eTag For optimistic concurrency control.
 * @property id Path reference to this private endpoint endpoint connection. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/privateEndpointConnections/{privateEndpointConnectionName}
 * @property name Name of the private endpoint endpoint connection.
 * @property properties Properties of the private endpoint endpoint connection.
 * @property type Type of the object = [Microsoft&#46;Migrate/assessmentProjects/privateEndpointConnections].
 */
public data class GetPrivateEndpointConnectionResult(
    public val eTag: String? = null,
    public val id: String,
    public val name: String,
    public val properties: PrivateEndpointConnectionPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetPrivateEndpointConnectionResult): GetPrivateEndpointConnectionResult = GetPrivateEndpointConnectionResult(
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
