@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Azure Migrate Project.
 * @property eTag For optimistic concurrency control.
 * @property id Path reference to this project /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}
 * @property location Azure location in which project is created.
 * @property name Name of the project.
 * @property properties Properties of the project.
 * @property tags Tags provided by Azure Tagging service.
 * @property type Type of the object = [Microsoft&#46;Migrate/assessmentProjects].
 */
public data class GetProjectResult(
    public val eTag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: ProjectPropertiesResponse,
    public val tags: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetProjectResult): GetProjectResult = GetProjectResult(
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.ProjectPropertiesResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
