@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class for GMSA authentication details to configure Active Directory connectivity.
 * @property adDomainControllerDns Gets or sets the list of dns server that can resolve the Active Directory Domain Name/Address.
 * @property adDomainFqdn Gets or sets the FQDN of the Active Directory Domain. For e.g. 'contoso.local', 'fareast.corp.microsoft.com' etc.
 * @property akvProperties
 * @property configurationState Gets or sets the current state of GMSA configuration.
 * @property domainAdminPassword Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.DomainAdminUsername.
 * @property domainAdminUsername Gets or sets the name of the user having admin rights on the Active Directory Domain Controller.
 * @property domainControllerAddress Gets or sets the address of the Active Directory Domain Controller running Domain Services.
 * @property gmsaAccountName Gets or sets the name to be used for GMSA.
 * @property gmsaCredSpecName Gets Cred Spec Name to be used.
 * @property gmsaSecretName Gets name of the secret where GMSA secret is stored in the KeyVault.
 * @property gmsaUserPassword Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.GmsaUsername.
 * @property gmsaUsername Gets or sets username of the user having authorization to access GMSA on Active Directory.
 */
public data class GmsaAuthenticationPropertiesResponse(
    public val adDomainControllerDns: String? = null,
    public val adDomainFqdn: String? = null,
    public val akvProperties: KeyVaultSecretStorePropertiesResponse? = null,
    public val configurationState: String,
    public val domainAdminPassword: String? = null,
    public val domainAdminUsername: String? = null,
    public val domainControllerAddress: String? = null,
    public val gmsaAccountName: String? = null,
    public val gmsaCredSpecName: String,
    public val gmsaSecretName: String,
    public val gmsaUserPassword: String? = null,
    public val gmsaUsername: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GmsaAuthenticationPropertiesResponse): GmsaAuthenticationPropertiesResponse = GmsaAuthenticationPropertiesResponse(
            adDomainControllerDns = javaType.adDomainControllerDns().map({ args0 -> args0 }).orElse(null),
            adDomainFqdn = javaType.adDomainFqdn().map({ args0 -> args0 }).orElse(null),
            akvProperties = javaType.akvProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.KeyVaultSecretStorePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            configurationState = javaType.configurationState(),
            domainAdminPassword = javaType.domainAdminPassword().map({ args0 -> args0 }).orElse(null),
            domainAdminUsername = javaType.domainAdminUsername().map({ args0 -> args0 }).orElse(null),
            domainControllerAddress = javaType.domainControllerAddress().map({ args0 -> args0 }).orElse(null),
            gmsaAccountName = javaType.gmsaAccountName().map({ args0 -> args0 }).orElse(null),
            gmsaCredSpecName = javaType.gmsaCredSpecName(),
            gmsaSecretName = javaType.gmsaSecretName(),
            gmsaUserPassword = javaType.gmsaUserPassword().map({ args0 -> args0 }).orElse(null),
            gmsaUsername = javaType.gmsaUsername().map({ args0 -> args0 }).orElse(null),
        )
    }
}
