@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines Private link service group connectivity.
 * @property customerVisibleFqdns
 * @property groupId
 * @property id
 * @property internalFqdn
 * @property memberName
 * @property privateLinkServiceArmRegion
 * @property redirectMapId
 */
public data class GroupConnectivityInformationResponse(
    public val customerVisibleFqdns: List<String>? = null,
    public val groupId: String? = null,
    public val id: String? = null,
    public val internalFqdn: String? = null,
    public val memberName: String? = null,
    public val privateLinkServiceArmRegion: String? = null,
    public val redirectMapId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GroupConnectivityInformationResponse): GroupConnectivityInformationResponse = GroupConnectivityInformationResponse(
            customerVisibleFqdns = javaType.customerVisibleFqdns().map({ args0 -> args0 }),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            internalFqdn = javaType.internalFqdn().map({ args0 -> args0 }).orElse(null),
            memberName = javaType.memberName().map({ args0 -> args0 }).orElse(null),
            privateLinkServiceArmRegion = javaType.privateLinkServiceArmRegion().map({ args0 ->
                args0
            }).orElse(null),
            redirectMapId = javaType.redirectMapId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
