@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of group resource.
 * @property areAssessmentsRunning If the assessments are in running state.
 * @property assessments List of References to Assessments created on this group.
 * @property createdTimestamp Time when this group was created. Date-Time represented in ISO-8601 format.
 * @property groupStatus Whether the group has been created and is valid.
 * @property groupType The type of group.
 * @property machineCount Number of machines part of this group.
 * @property updatedTimestamp Time when this group was last updated. Date-Time represented in ISO-8601 format.
 */
public data class GroupPropertiesResponse(
    public val areAssessmentsRunning: Boolean,
    public val assessments: List<String>,
    public val createdTimestamp: String,
    public val groupStatus: String,
    public val groupType: String? = null,
    public val machineCount: Int,
    public val updatedTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GroupPropertiesResponse): GroupPropertiesResponse = GroupPropertiesResponse(
            areAssessmentsRunning = javaType.areAssessmentsRunning(),
            assessments = javaType.assessments().map({ args0 -> args0 }),
            createdTimestamp = javaType.createdTimestamp(),
            groupStatus = javaType.groupStatus(),
            groupType = javaType.groupType().map({ args0 -> args0 }).orElse(null),
            machineCount = javaType.machineCount(),
            updatedTimestamp = javaType.updatedTimestamp(),
        )
    }
}
