@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Representation of a licence.
 * @property licenseCost Cost of a licence.
 * @property licenseType HyperV licence type.
 */
public data class HypervLicenseResponse(
    public val licenseCost: Double,
    public val licenseType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.HypervLicenseResponse): HypervLicenseResponse = HypervLicenseResponse(
            licenseCost = javaType.licenseCost(),
            licenseType = javaType.licenseType(),
        )
    }
}
