@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IIS workload instance model custom properties.
 * @property iisAksWorkloadDeploymentProperties IIS AKS workload deployment.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'IISAKSWorkloadDeploymentModelCustomProperties'.
 */
public data class IISAKSWorkloadDeploymentModelCustomPropertiesResponse(
    public val iisAksWorkloadDeploymentProperties: IISAKSWorkloadDeploymentResponse? = null,
    public val instanceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.IISAKSWorkloadDeploymentModelCustomPropertiesResponse): IISAKSWorkloadDeploymentModelCustomPropertiesResponse =
            IISAKSWorkloadDeploymentModelCustomPropertiesResponse(
                iisAksWorkloadDeploymentProperties = javaType.iisAksWorkloadDeploymentProperties().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.migrate.kotlin.outputs.IISAKSWorkloadDeploymentResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                instanceType = javaType.instanceType(),
            )
    }
}
