@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * IIS virtual application details.
 * @property directories Gets or sets the list of directories.
 * @property id Gets the ID.
 * @property isVirtualDirectory Gets a value indicating whether the application corresponds to a directory.
 * @property path Second level entity for virtual directories.
 */
public data class IISVirtualApplicationDetailsResponse(
    public val directories: List<DirectoryPathResponse>? = null,
    public val id: String,
    public val isVirtualDirectory: Boolean,
    public val path: DirectoryPathResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.IISVirtualApplicationDetailsResponse): IISVirtualApplicationDetailsResponse = IISVirtualApplicationDetailsResponse(
            directories = javaType.directories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.DirectoryPathResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            isVirtualDirectory = javaType.isVirtualDirectory(),
            path = javaType.path().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.DirectoryPathResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
