@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * IISWeb application.
 * @property applicationId Gets or sets the web application id.
 * @property applicationName Gets or sets the web application name.
 * @property applicationScratchPath Gets or sets application scratch path.
 * @property applications Gets or sets the list of applications for the IIS web site.
 * @property bindings Gets or sets the bindings for the application.
 * @property configurations Gets or sets application configuration.
 * @property directories Gets or sets application directories.
 * @property discoveredFrameworks Gets or sets the discovered frameworks of application.
 * @property displayName Gets or sets the display name.
 * @property iisWebServer IISWeb server.
 * @property limits Resource Requirements.
 * @property path Second level entity for virtual directories.
 * @property primaryFramework Framework specific data for a web application.
 * @property requests Resource Requirements.
 * @property virtualApplications Gets or sets the list of application units for the web site.
 * @property webServerId Gets or sets the web server id.
 * @property webServerName Gets or sets the web server name.
 */
public data class IISWebApplicationResponse(
    public val applicationId: String? = null,
    public val applicationName: String? = null,
    public val applicationScratchPath: String? = null,
    public val applications: List<IISApplicationDetailsResponse>? = null,
    public val bindings: List<BindingResponse>? = null,
    public val configurations: List<WebApplicationConfigurationResponse>? = null,
    public val directories: List<WebApplicationDirectoryResponse>? = null,
    public val discoveredFrameworks: List<WebApplicationFrameworkResponse>? = null,
    public val displayName: String? = null,
    public val iisWebServer: IISWebServerResponse? = null,
    public val limits: ResourceRequirementsResponse? = null,
    public val path: DirectoryPathResponse? = null,
    public val primaryFramework: WebApplicationFrameworkResponse? = null,
    public val requests: ResourceRequirementsResponse? = null,
    public val virtualApplications: List<IISVirtualApplicationDetailsResponse>? = null,
    public val webServerId: String? = null,
    public val webServerName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.IISWebApplicationResponse): IISWebApplicationResponse = IISWebApplicationResponse(
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            applicationName = javaType.applicationName().map({ args0 -> args0 }).orElse(null),
            applicationScratchPath = javaType.applicationScratchPath().map({ args0 -> args0 }).orElse(null),
            applications = javaType.applications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.IISApplicationDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            bindings = javaType.bindings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.BindingResponse.Companion.toKotlin(args0)
                })
            }),
            configurations = javaType.configurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.WebApplicationConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            directories = javaType.directories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.WebApplicationDirectoryResponse.Companion.toKotlin(args0)
                })
            }),
            discoveredFrameworks = javaType.discoveredFrameworks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.WebApplicationFrameworkResponse.Companion.toKotlin(args0)
                })
            }),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            iisWebServer = javaType.iisWebServer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.IISWebServerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            limits = javaType.limits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ResourceRequirementsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            path = javaType.path().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.DirectoryPathResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            primaryFramework = javaType.primaryFramework().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.WebApplicationFrameworkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requests = javaType.requests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ResourceRequirementsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            virtualApplications = javaType.virtualApplications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.IISVirtualApplicationDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            webServerId = javaType.webServerId().map({ args0 -> args0 }).orElse(null),
            webServerName = javaType.webServerName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
