@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity model.
 * @property aadAuthority Gets or sets the authority of the SPN with which MigrateAgent communicates to service.
 * @property applicationId Gets or sets the client/application Id of the SPN with which MigrateAgent communicates to
 * service.
 * @property audience Gets or sets the audience of the SPN with which MigrateAgent communicates to service.
 * @property objectId Gets or sets the object Id of the SPN with which MigrateAgent communicates to service.
 * @property tenantId Gets or sets the tenant Id of the SPN with which MigrateAgent communicates to service.
 */
public data class IdentityModelResponse(
    public val aadAuthority: String? = null,
    public val applicationId: String? = null,
    public val audience: String? = null,
    public val objectId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.IdentityModelResponse): IdentityModelResponse = IdentityModelResponse(
            aadAuthority = javaType.aadAuthority().map({ args0 -> args0 }).orElse(null),
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            audience = javaType.audience().map({ args0 -> args0 }).orElse(null),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
