@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines Private link IP configuration.
 * @property groupId
 * @property id
 * @property linkIdentifier
 * @property memberName
 * @property privateIpAddress
 */
public data class IpConfigurationResponse(
    public val groupId: String? = null,
    public val id: String? = null,
    public val linkIdentifier: String? = null,
    public val memberName: String? = null,
    public val privateIpAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.IpConfigurationResponse): IpConfigurationResponse = IpConfigurationResponse(
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            linkIdentifier = javaType.linkIdentifier().map({ args0 -> args0 }).orElse(null),
            memberName = javaType.memberName().map({ args0 -> args0 }).orElse(null),
            privateIpAddress = javaType.privateIpAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
