@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property inputType
 * @property keyvaultName
 * @property managedIdentityProperties
 * @property resourceGroup
 * @property secretStoreId
 * @property subscriptionId
 * @property tenantId
 */
public data class KeyVaultSecretStorePropertiesResponse(
    public val inputType: String,
    public val keyvaultName: String? = null,
    public val managedIdentityProperties: ManagedIdentityPropertiesResponse? = null,
    public val resourceGroup: String? = null,
    public val secretStoreId: String? = null,
    public val subscriptionId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.KeyVaultSecretStorePropertiesResponse): KeyVaultSecretStorePropertiesResponse = KeyVaultSecretStorePropertiesResponse(
            inputType = javaType.inputType(),
            keyvaultName = javaType.keyvaultName().map({ args0 -> args0 }).orElse(null),
            managedIdentityProperties = javaType.managedIdentityProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ManagedIdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            secretStoreId = javaType.secretStoreId().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
