@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines reference to load balancer backend address pools.
 * @property name Gets the name of the proxy resource on the target side.
 * @property sourceArmResourceId Gets the ARM resource ID of the tracked resource being referenced.
 */
public data class LoadBalancerBackendAddressPoolReferenceResponse(
    public val name: String? = null,
    public val sourceArmResourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.LoadBalancerBackendAddressPoolReferenceResponse): LoadBalancerBackendAddressPoolReferenceResponse =
            LoadBalancerBackendAddressPoolReferenceResponse(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                sourceArmResourceId = javaType.sourceArmResourceId(),
            )
    }
}
