@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines the load balancer resource settings.
 * @property backendAddressPools Gets or sets the backend address pools of the load balancer.
 * @property frontendIPConfigurations Gets or sets the frontend IP configurations of the load balancer.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Network/loadBalancers'.
 * @property sku Gets or sets load balancer sku (Basic/Standard).
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 * @property zones Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given
 *  precedence only if frontend IP configurations settings are not present.
 */
public data class LoadBalancerResourceSettingsResponse(
    public val backendAddressPools: List<LBBackendAddressPoolResourceSettingsResponse>? = null,
    public val frontendIPConfigurations: List<LBFrontendIPConfigurationResourceSettingsResponse>? =
        null,
    public val resourceType: String,
    public val sku: String? = null,
    public val tags: Map<String, String>? = null,
    public val targetResourceGroupName: String? = null,
    public val targetResourceName: String,
    public val zones: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.LoadBalancerResourceSettingsResponse): LoadBalancerResourceSettingsResponse = LoadBalancerResourceSettingsResponse(
            backendAddressPools = javaType.backendAddressPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.LBBackendAddressPoolResourceSettingsResponse.Companion.toKotlin(args0)
                })
            }),
            frontendIPConfigurations = javaType.frontendIPConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.LBFrontendIPConfigurationResourceSettingsResponse.Companion.toKotlin(args0)
                })
            }),
            resourceType = javaType.resourceType(),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceGroupName = javaType.targetResourceGroupName().map({ args0 -> args0 }).orElse(null),
            targetResourceName = javaType.targetResourceName(),
            zones = javaType.zones().map({ args0 -> args0 }).orElse(null),
        )
    }
}
