@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Suppress

/**
 * Management settings.
 * @property hypervVirtualizationManagementSettings HyperV Virtualization Management Settings.
 * @property otherManagementCostsSettings Other Management Costs Settings.
 * @property thirdPartyManagementSettings Third Party Management Settings.
 * @property vsphereManagementSettings vSphere Management Settings.
 */
public data class ManagementSettingsResponse(
    public val hypervVirtualizationManagementSettings: HypervVirtualizationManagementSettingsResponse,
    public val otherManagementCostsSettings: OtherManagementCostsSettingsResponse,
    public val thirdPartyManagementSettings: ThirdPartyManagementSettingsResponse,
    public val vsphereManagementSettings: VsphereManagementSettingsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ManagementSettingsResponse): ManagementSettingsResponse = ManagementSettingsResponse(
            hypervVirtualizationManagementSettings = javaType.hypervVirtualizationManagementSettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.HypervVirtualizationManagementSettingsResponse.Companion.toKotlin(args0)
            }),
            otherManagementCostsSettings = javaType.otherManagementCostsSettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.OtherManagementCostsSettingsResponse.Companion.toKotlin(args0)
            }),
            thirdPartyManagementSettings = javaType.thirdPartyManagementSettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.ThirdPartyManagementSettingsResponse.Companion.toKotlin(args0)
            }),
            vsphereManagementSettings = javaType.vsphereManagementSettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.VsphereManagementSettingsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
